package com.vf106.tools.utils;

import java.nio.charset.Charset;

/**
 * Conversion of bytes
 * Created by jerry on 2017/4/27.
 */

public class ByteUtils {

    /**
     * Returns a string converted from a byte array.
     *
     * @param bytes byte array
     * @return string
     */
    public static String toString(byte[] bytes) {
        return new String(bytes, Charset.forName("UTF-8"));
    }

    /**
     * Returns a string converted from a byte array.
     *
     * @param bytes byte array
     * @param charsetName charset encoding
     * @return string
     */
    public static String toString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    // --------------------------------------------------------------------------------------------

}


